/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.attach;

import co.elastic.apm.attach.PgpSignatureVerifier;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.CopyOption;
import java.nio.file.FileSystem;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Collections;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PgpSignatureVerifierLoader
extends URLClassLoader {
    private final String verifierImplementationName;

    static PgpSignatureVerifierLoader getInstance(String sourceLib, final Path targetLib, String verifierClassName) throws Exception {
        Path libPath;
        final Logger logger = LogManager.getLogger(PgpSignatureVerifierLoader.class);
        URL resourceUrl = PgpSignatureVerifierLoader.class.getResource(sourceLib);
        if (resourceUrl != null) {
            URI libUri = resourceUrl.toURI();
            if (libUri.getScheme().equals("jar")) {
                FileSystem fileSystem;
                try {
                    fileSystem = FileSystems.getFileSystem(libUri);
                }
                catch (FileSystemNotFoundException e) {
                    fileSystem = FileSystems.newFileSystem(libUri, Collections.emptyMap());
                }
                libPath = fileSystem.getPath(sourceLib, new String[0]);
            } else {
                libPath = Paths.get(libUri);
            }
        } else {
            libPath = Paths.get(sourceLib, new String[0]);
        }
        logger.debug("Traversing [{}] for PGP signature verifier implementation and related dependencies", (Object)libPath);
        if (!Files.exists(libPath, new LinkOption[0])) {
            throw new IllegalArgumentException(String.format("%s dir cannot be found", sourceLib));
        }
        final ArrayList urlList = new ArrayList();
        Files.walkFileTree(libPath, (FileVisitor<? super Path>)new FileVisitor<Path>(){

            @Override
            public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) {
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                String fileName = file.getFileName().toString();
                if (fileName.endsWith(".jar")) {
                    boolean copyJar = true;
                    Path jarInTargetLib = Paths.get(targetLib.toString(), fileName);
                    if (Files.exists(jarInTargetLib, new LinkOption[0])) {
                        logger.trace("{} already exists at {}", (Object)fileName, (Object)targetLib);
                        if (Files.isReadable(jarInTargetLib)) {
                            copyJar = false;
                        } else {
                            logger.info("{} is not readable for the current user, removing and copying new one", (Object)jarInTargetLib);
                            Files.delete(jarInTargetLib);
                        }
                    }
                    if (copyJar) {
                        logger.debug("Copying {} to {}", (Object)fileName, (Object)targetLib);
                        Files.copy(file, jarInTargetLib, new CopyOption[0]);
                    }
                    urlList.add(jarInTargetLib.toUri().toURL());
                }
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult visitFileFailed(Path file, IOException exc) throws IOException {
                throw exc;
            }

            @Override
            public FileVisitResult postVisitDirectory(Path dir, IOException exc) {
                return FileVisitResult.CONTINUE;
            }
        });
        if (urlList.isEmpty()) {
            throw new IllegalArgumentException(String.format("%s dir is empty", sourceLib));
        }
        logger.debug("{} directory contents: {}", (Object)sourceLib, (Object)urlList);
        return new PgpSignatureVerifierLoader(urlList.toArray(new URL[0]), verifierClassName);
    }

    private PgpSignatureVerifierLoader(URL[] urls, String verifierImplementationName) {
        super(urls, PgpSignatureVerifier.class.getClassLoader());
        this.verifierImplementationName = verifierImplementationName;
    }

    PgpSignatureVerifier loadPgpSignatureVerifier() throws Exception {
        Class<?> verifierImplementationClass = this.loadClass(this.verifierImplementationName);
        Logger logger = LogManager.getLogger(PgpSignatureVerifierLoader.class);
        logger.debug("{} class loaded by {}", (Object)verifierImplementationClass.getName(), (Object)verifierImplementationClass.getClassLoader());
        return (PgpSignatureVerifier)verifierImplementationClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
    }
}

