/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.attach;

import co.elastic.apm.agent.common.util.ProcessExecutionUtil;
import co.elastic.apm.attach.JvmAttachUtils;
import co.elastic.apm.attach.JvmInfo;
import co.elastic.apm.attach.UserRegistry;
import java.io.IOException;
import java.io.StringReader;
import java.util.Arrays;
import java.util.Properties;

public class GetAgentProperties {
    public static void main(String[] args) throws Exception {
        JvmAttachUtils.getAgentAndSystemProperties(args[0]).store(System.out, null);
    }

    public static Properties getAgentAndSystemProperties(String pid, UserRegistry.User user) throws Exception {
        if (user.isCurrentUser() && !JvmInfo.CURRENT_PID.equals(pid)) {
            return JvmAttachUtils.getAgentAndSystemProperties(pid);
        }
        return GetAgentProperties.getAgentAndSystemPropertiesSwitchUser(pid, user);
    }

    static Properties getAgentAndSystemPropertiesSwitchUser(String pid, UserRegistry.User user) throws IOException {
        ProcessExecutionUtil.CommandOutput output = user.executeAsUserWithCurrentClassPath(GetAgentProperties.class, Arrays.asList(pid, user.getUsername()));
        if (output.getExitCode() == 0) {
            Properties properties = new Properties();
            properties.load(new StringReader(output.getOutput().toString()));
            return properties;
        }
        throw new RuntimeException(output.getOutput().toString(), output.getExceptionThrown());
    }
}

