#!/usr/bin/env sh

set -e

if [[ $BLU_USE_OUTBOUND_HTTP_PROXY = "1" ]]; then
  echo "Setting ENV for http/s_proxy"
  export http_proxy="${BLU_OUTBOUND_HTTP_PROXY}"
fi

if [[ $BLU_USE_OUTBOUND_HTTPS_PROXY = "1" ]]; then
  echo "Setting ENV for http/s_proxy"
  export https_proxy="${BLU_OUTBOUND_HTTP_PROXY}"
fi

if [[ $BLU_USE_OUTBOUND_HTTP_PROXY = "1" ]] || [[ $BLU_USE_OUTBOUND_HTTPS_PROXY = "1" ]]; then
  echo "Setting ENV for no_proxy"
  export no_proxy="${BLU_NO_PROXY}"
  echo "Setting git config parameters"
  git config --global http.proxy "${BLU_OUTBOUND_HTTP_PROXY}"
  git config --global protocol.file.allow never
  git config --global protocol.git.allow never
  git config --global protocol.ftp.allow never
  git config --global protocol.ext.allow never
fi
exec "$@"
