# Deploy Vault Radar Agent to Kubernetes

This guide walks through a deployment of Vault Radar Agent to a kubernetes cluster
This is a simple quick start example. It should not be deployed to a production environment without modifications that are in line with industry best practices.

### Prerequisites

- [HCP Vault Radar access](https://vault-radar-portal.cloud.hashicorp.com)
- [Vault Radar Docker Image](https://hub.docker.com/r/hashicorp/vault-radar)
- [Kubectl](https://kubernetes.io/docs/tasks/tools)

## Create a Agent in the HCP Vault Radar portal

- Create Service principal and key
  - [Create a service principal and service principal key](https://developer.hashicorp.com/hcp/docs/vault-radar/manage/agent/overview#create-a-service-principal)
  - Copy and save the “Client ID” and “Client Key” to use later
- Create Agent
  - Login to the [HCP portal](https://portal.cloud.hashicorp.com)
  - Select “Vault Radar” from the navigation menu
  - In Vault Radar navigate to “Settings” then select “Agent” from the navigation menu
  - Select the “+ Add a Agent button
  - Give it a name
  - Copy and save `HCP_PROJECT_ID` and `HCP_RADAR_AGENT_POOL_ID` to use later
  - Select the “Install Agent” button

### Set environment variables

- Retrieve `Client ID` and `Client Key` from when the HCP service principal was created
  - Client ID = `HCP_CLIENT_ID`
  - Client Key = `HCP_CLIENT_SECRET`
- Retrieve `Project ID` and `Vault Radar Agent Pool ID` from when the Agent was created
- HCP Project ID = `HCP_PROJECT_ID`
- HCP Vault Radar Agent Pool ID = `HCP_RADAR_AGENT_POOL_ID`
- Obtain a `Git Token` that has read access to the desired target repos that Agent will be accessing
  - Git Token = `VAULT_RADAR_GIT_TOKEN`
    - For GitHub or GitLab use a personal access token (PAT)
    - For BitBucket and Azure DevOps, it should be in the format as `<username>:<PAT>`
- In the code block below replace `PLACEHOLDER` with their respective values
-

```
export IMAGE_REPOSITORY="docker.io/hashicorp/vault-radar"
export IMAGE_TAG="latest"
export HCP_API_ADDRESS="api.cloud.hashicorp.com"
export HCP_AUTH_URL="https://auth.idp.hashicorp.com"

export HCP_PROJECT_ID_BASE64=$(echo -n "PLACEHOLDER" | base64)
export HCP_RADAR_AGENT_POOL_ID_BASE64=$(echo -n "PLACEHOLDER" | base64)
export HCP_CLIENT_ID_BASE64=$(echo -n "PLACEHOLDER" | base64)
export HCP_CLIENT_SECRET_BASE64=$(echo -n "PLACEHOLDER" | base64)
export VAULT_RADAR_GIT_TOKEN_BASE64=$(echo -n "PLACEHOLDER" | base64)
```

### Replace the placeholder variables in the Kubernetes manifest file

**Easy button:** Install `envsubst`

```
# macos
brew install gettext
brew link --force gettext
```

```
# ubuntu
apt-get install -y gettext
```

```
# Replaces the variables in the manifest yaml file
envsubst < agent.yaml > output.yaml
```

**Hard button:** manually replace the environment variables in the `agent.yaml` file with their intended values

## Its go time!

### Deploy Agent to Kubernetes

```
kubectl apply -f output.yaml
```

## Teardown Vault Radar Agent / Cleanup

```
# Delete deployment
kubectl delete -f output.yaml
# Delete output.yaml
rm output.yaml
```
